/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import vazkii.botania.client.fx.ModParticles;

public class WispParticleData
implements ParticleOptions {
    public static final Codec<WispParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("size").forGetter(d -> Float.valueOf(d.size)), (App)Codec.FLOAT.fieldOf("r").forGetter(d -> Float.valueOf(d.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(d -> Float.valueOf(d.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(d -> Float.valueOf(d.b)), (App)Codec.FLOAT.fieldOf("maxAgeMul").forGetter(d -> Float.valueOf(d.maxAgeMul)), (App)Codec.BOOL.fieldOf("depthTest").forGetter(d -> d.depthTest), (App)Codec.BOOL.fieldOf("noClip").forGetter(d -> d.noClip)).apply((Applicative)instance, WispParticleData::new));
    public final float size;
    public final float r;
    public final float g;
    public final float b;
    public final float maxAgeMul;
    public final boolean depthTest;
    public final boolean noClip;
    public static final ParticleOptions.Deserializer<WispParticleData> DESERIALIZER = new ParticleOptions.Deserializer<WispParticleData>(){

        @Nonnull
        public WispParticleData fromCommand(@Nonnull ParticleType<WispParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float mam = reader.readFloat();
            boolean depth = true;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            boolean noClip = false;
            if (reader.canRead()) {
                reader.expect(' ');
                depth = reader.readBoolean();
            }
            return new WispParticleData(size, r, g, b, mam, depth, noClip);
        }

        public WispParticleData fromNetwork(@Nonnull ParticleType<WispParticleData> type, FriendlyByteBuf buf) {
            return new WispParticleData(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readBoolean());
        }
    };

    public static WispParticleData wisp(float size, float r, float g, float b) {
        return WispParticleData.wisp(size, r, g, b, 1.0f);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul) {
        return WispParticleData.wisp(size, r, g, b, maxAgeMul, true);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, boolean depth) {
        return WispParticleData.wisp(size, r, g, b, 1.0f, depth);
    }

    public static WispParticleData wisp(float size, float r, float g, float b, float maxAgeMul, boolean depthTest) {
        return new WispParticleData(size, r, g, b, maxAgeMul, depthTest, false);
    }

    private WispParticleData(float size, float r, float g, float b, float maxAgeMul, boolean depthTest, boolean noClip) {
        this.size = size;
        this.r = r;
        this.g = g;
        this.b = b;
        this.maxAgeMul = maxAgeMul;
        this.depthTest = depthTest;
        this.noClip = noClip;
    }

    public WispParticleData withNoClip(boolean v) {
        if (this.noClip == v) {
            return this;
        }
        return new WispParticleData(this.size, this.r, this.g, this.b, this.maxAgeMul, this.depthTest, v);
    }

    @Nonnull
    public ParticleType<WispParticleData> m_6012_() {
        return ModParticles.WISP;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.writeFloat(this.size);
        buf.writeFloat(this.r);
        buf.writeFloat(this.g);
        buf.writeFloat(this.b);
        buf.writeFloat(this.maxAgeMul);
        buf.writeBoolean(this.depthTest);
        buf.writeBoolean(this.noClip);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %s", Registry.f_122829_.m_7981_(this.m_6012_()), Float.valueOf(this.size), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.maxAgeMul), this.depthTest);
    }
}

